#include <stdio.h>
#include <stdlib.h>


typedef struct {
    int x, y;
} Point;


int compare_points(const void *a, const void *b) {
    Point *p1 = (Point *)a;
    Point *p2 = (Point *)b;

    if (p1->x == p2->x) {
        return p1->y - p2->y;
    }
    return p1->x - p2->x;
}


int cross(Point o, Point a, Point b) {
    return (a.x - o.x) * (b.y - o.y) - (a.y - o.y) * (b.x - o.x);
}


long long polygon_area(Point *points, int n) {
    long long area = 0;
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        area += (long long)points[i].x * points[j].y;
        area -= (long long)points[j].x * points[i].y;
    }
    return llabs(area) / 2;
}


int convex_hull(Point *points, int n, Point *hull) {
  
    qsort(points, n, sizeof(Point), compare_points);

    int k = 0;


    for (int i = 0; i < n; i++) {
        while (k >= 2 && cross(hull[k-2], hull[k-1], points[i]) <= 0) {
            k--;
        }
        hull[k++] = points[i];
    }

  
    int t = k + 1;
    for (int i = n - 1; i >= 0; i--) {
        while (k >= t && cross(hull[k-2], hull[k-1], points[i]) <= 0) {
            k--;
        }
        hull[k++] = points[i];
    }

    return k - 1; 
}

int main() {
    int N;
    scanf("%d", &N);
    
    Point points[N];
    for (int i = 0; i < N; i++) {
        scanf("%d %d", &points[i].x, &points[i].y);
    }

  
    Point hull[N];
    int hull_size = convex_hull(points, N, hull);
    
   
    long long area = polygon_area(hull, hull_size);
    
    long long min_area = area;  
    for (int i = 0; i < N; i++) {
        Point reduced_points[N-1];
        int index = 0;
        for (int j = 0; j < N; j++) {
            if (i != j) {
                reduced_points[index++] = points[j];
            }
        }
        Point reduced_hull[N-1];
        int reduced_hull_size = convex_hull(reduced_points, N-1, reduced_hull);
        long long reduced_area = polygon_area(reduced_hull, reduced_hull_size);
        if (reduced_area < min_area) {
            min_area = reduced_area;
        }
    }

    printf("%lld\n", min_area);

    return 0;
}